/*****************************************
* Klasse Open
*
* Beschreibung: Erffnen einer Verbindung
* Application calls
* Autor: Gunter Weiss
*****************************************/
import java.util.Vector;
import java.util.Date;

public class Open {

TcpProtocol parent;
ThreadGroup halt;

/*****************************************
* Methode Open
* Beschreibung: Verbindung eroeffnen
* Parameter: short local port, short destination port, int passive oder active
* Rueckgabewert: int 0 = OK, int -1 = nicht OK (erfolgreich)
* Autor: Gunter Wei
*****************************************/

public final synchronized int Open( TcpProtocol home, short Lport, short Dport, int stat){

this .parent = home;
halt = parent.outerparent.halt;

int vorhanden;
vorhanden = new Suche().port(Lport,parent.tcbbuffer);
if (vorhanden != -1) {   // pruefe ob dieser Port nicht schon belegt ist.
  SessionControlBlock scb = new SessionControlBlock();
  scb =((SessionControlBlock)parent.tcbbuffer.elementAt(vorhanden));
  switch(scb.TcpStatus) {
    case 0:
        if( stat == 0 ) {
           scb.TcpStatus = 1;
           TcpSegment dummyserv = new TcpSegment();
           parent. history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,"LISTEN"));
	   switch (parent.my_host){
	   case 1:
	     parent. outerparent.host2.t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,parent.outerparent.chkstat.getState(parent.outerparent.host2)));
	     break;
	   case 2:
	     parent. outerparent.host1.t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,parent.outerparent.chkstat.getState(parent.outerparent.host1)));
	     break;
	     }
           return vorhanden;
        }
        if(( stat == 1 )&( Dport >= 0 )) {
           scb.TcpStatus = 2;
           int k = new SqNbGenerator().getISS(parent.time);
           TcpSegment seg = new TcpSegment();
           seg.Lpnumb = Lport;
           seg.Dpnumb = Dport;
           seg.SYN = 1;
           seg.Hdlength = 5;
           scb.SNDUNA = k;
           scb.SNDNXT = k +1;
           seg.Wsize =(short)(scb.toclientbuffer.capacity()-scb.toclientbuffer.size());
           seg = new Checksum().build(seg);
           scb.setack.acksem = true;
           Timeout t0 = new Timeout(halt,parent,2,parent.tcbbuffer,scb);
           //t0.start();
           int n1 = new WaitForAck().WaitForAck(halt,parent,seg,parent.tonetbuffer,scb,"SYN_SENT");
           switch(n1){
             case 0:
               return vorhanden;
             default:
               scb.TcpStatus = 0;
               if((vorhanden = new Suche().port(Lport,parent.tcbbuffer))>=0){
                 parent. tcbbuffer.removeElementAt(vorhanden);
    	         parent.cid--;
    	       }
               return -1;
           }
         }
         else return -5;

    case 1:
         if(( stat == 1 )&( Dport >= 0 )) {
           scb.TcpStatus = 2;
           int k = new SqNbGenerator().getISS(parent.time);
           TcpSegment seg = new TcpSegment();
           seg.Lpnumb = Lport;
           seg.Dpnumb = Dport;
           seg.SYN = 1;
           seg.Hdlength = 5;
           scb.SNDUNA = k;
           scb.SNDNXT = k +1;
           seg.Wsize =(short)(scb.toclientbuffer.capacity()-scb.toclientbuffer.size());
           seg = new Checksum().build(seg);
           scb.setack.acksem =true;
           Timeout t1 = new Timeout(halt,parent,2,parent.tcbbuffer,scb);
           int n = new WaitForAck().WaitForAck(halt,parent,seg,parent.tonetbuffer,scb,"SYN_SENT");
           switch(n){
             case 0:
               return vorhanden;
             default:
               scb.TcpStatus = 0;
    	       if((vorhanden = new Suche().port(Lport,parent.tcbbuffer))>=0){
    	         parent. tcbbuffer.removeElementAt(vorhanden);
    	         parent.cid--;
    	       }
               return -1;
           }

         }
         else return -5;
    default:    // von switch(scb.TcpStatus)
         return -3;
  }             // Ende von switch(scb.TcpStatus)
}
else {
  if (parent.cid < parent.max_cid){ // port ist noch nicht belegt
      parent.ncid = parent.cid;
      parent.cid++;
      parent. tcbbuffer.addElement(new CreateTCB().createtcb( parent.ncid, Lport, Dport, stat));
      int j = new Suche().conid(parent.ncid,parent.tcbbuffer);
      SessionControlBlock neutcb = new SessionControlBlock();
      neutcb = ((SessionControlBlock)parent.tcbbuffer.elementAt(j));
      switch(stat){ // je nach TCPStatus tue
        case 0: //Status "CLOSED"
	  neutcb.TcpStatus = 1; // neuer Status ist LISTEN
            TcpSegment dummyserv = new TcpSegment();
            parent.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,"LISTEN"));
	    switch (parent.my_host){
	    case 1:
	      parent.outerparent.host2.t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,parent.outerparent.chkstat.getState(parent.outerparent.host2)));
	      break;
	    case 2:
	      parent.outerparent.host1.t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,parent.outerparent.chkstat.getState(parent.outerparent.host1)));
	      break;
	    }
            return j;
        case 1: //Status "LISTEN"
            if(Dport <=0) {
                parent. tcbbuffer.removeElementAt(j);
                parent.cid--;
                return -1;
            }
            int k = new SqNbGenerator().getISS(parent.time);
            TcpSegment segobj = new TcpSegment();
            segobj.Lpnumb = Lport;
            segobj.Dpnumb = Dport;
            segobj.Seqnumb = k;
            segobj.SYN = 1;
            segobj.Hdlength = 5;
            segobj.Wsize =(short)(neutcb.toclientbuffer.capacity()-neutcb.toclientbuffer.size());
            segobj = new Checksum().build(segobj);
            neutcb.SNDUNA = k;
            neutcb.SNDNXT = k +1;
            neutcb.TcpStatus = 2;
            neutcb.setack.acksem = true;
            Timeout t2 = new Timeout(halt,parent,2,parent.tcbbuffer,neutcb);
            int z = new WaitForAck().WaitForAck(halt,parent,segobj,parent.tonetbuffer,neutcb,"SYN_SENT");
            switch(z){
              case 0:
                  return j;
              default:
                  neutcb.TcpStatus = 0;
        	      if((j = new Suche().conid(parent.ncid,parent.tcbbuffer))>=0){
                    parent. tcbbuffer.removeElementAt(j);
        	        parent.cid--;
        	      }
                  return -1;
            }
        default:
            if((j = new Suche().conid(parent.ncid,parent.tcbbuffer))>=0){
              parent. tcbbuffer.removeElementAt(j);
    	      parent.cid--;
    	    }
            return -1;
      }
  }
  else {return -4;}
}

}
}
